package com.xebialabs.xlrelease.configuration;

import java.util.List;
import java.util.stream.Collectors;

import static java.util.Arrays.stream;

public enum CustomLogoContentType {
    IMAGE_GIF("image/gif"),
    IMAGE_JPEG("image/jpeg"),
    IMAGE_PNG("image/png"),
    IMAGE_SVG_XML("image/svg+xml"),
    IMAGE_TIFF("image/tiff"),
    IMAGE_X_ICON("image/x-icon"),
    IMAGE_VND_MICROSOFT_ICON("image/vnd.microsoft.icon");

    private String value;

    CustomLogoContentType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static List<String> getAllTypes() {
        return stream(values()).map(CustomLogoContentType::value).collect(Collectors.toList());
    }

    public static List<String> getBrowserTypes() {
        return getAllTypes().stream()
                .filter(v -> !v.equals(CustomLogoContentType.IMAGE_VND_MICROSOFT_ICON.value()))
                .collect(Collectors.toList());
    }
}
