package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.security.authority.TenantAuthority
import com.xebialabs.xlrelease.utils.TenantContext.SYSTEM_TENANT_ID
import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

import scala.jdk.CollectionConverters._

trait TenantContext {
  def getTenant(): String

  def isSystemTenant(): Boolean = SYSTEM_TENANT_ID == getTenant()
}

object TenantContext extends TenantContext {
  final val SYSTEM_TENANT_ID: String = "00000000-0000-0000-0000-000000000000"

  override def getTenant(): String = {
    val auth = SecurityContextHolder.getContext.getAuthentication
    if (null != auth) {
      getTenantId(auth)
    } else {
      SYSTEM_TENANT_ID
    }
  }

  private def getTenantId(authentication: Authentication): String = {
    authentication.getAuthorities.asScala
      .collectFirst { case authority: TenantAuthority => authority.getAuthority }
      .orNull
  }
}
