package com.xebialabs.xlrelease.repository

import com.xebialabs.xlrelease.repository.Ids.{getName, normalizeId, triggerIdFrom}

object IdMatchers {

  sealed trait Id

  object AttachmentId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isAttachmentId)
  }

  object PlanItemId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isPlanItemId)
  }

  object TaskId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isTaskId)
  }

  object PhaseId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isPhaseId)
  }

  object ReleaseId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isReleaseId)
  }

  object DependencyId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isDependencyId)
  }

  object FolderId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isFolderId)
  }

  object VariableId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isVariableId)
  }

  object ConfigurationId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isConfigurationId)
  }

  object ValueProviderId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isValueProviderId)
  }

  object DeliveryId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isDeliveryId)
  }

  object TriggerId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isTriggerId)

    def actorName(id: String) = normalizeId(getName(triggerIdFrom(id)))
  }

  object EnvironmentLabelId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isEnvironmentLabelId)
  }

  object EnvironmentStageId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isEnvironmentStageId)
  }

  object EnvironmentId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isEnvironmentId)
  }

  object ApplicationId extends Id {
    def unapply(id: String): Option[String] = Some(id).filter(Ids.isApplicationId)
  }
}
