/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import java.util.HashSet;
import java.util.function.Predicate;

public class WordUtils {
    private WordUtils() {
    }

    public static String convertToTitleCase(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        value = value.toLowerCase().stripLeading();
        int valueLen = value.length();
        int[] charPoints = new int[valueLen];
        int outOffset = 0;
        Integer delimiter = Character.codePointAt(new char[]{' '}, 0);
        boolean capitalizeNext = true;
        int index = 0;
        while (index < valueLen) {
            int codePoint = value.codePointAt(index);
            if (delimiter == codePoint) {
                capitalizeNext = outOffset != 0;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                charPoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            charPoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        if (outOffset != 0) {
            return new String(charPoints, 0, outOffset);
        }
        return value;
    }

    public static String capitalize(String str) {
        return WordUtils.capitalize(str, null);
    }

    public static String capitalize(String str, char ... delimiters) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        Predicate<Integer> isDelimiter = WordUtils.generateIsDelimiterFunction(delimiters);
        int strLen = str.length();
        int[] newCodePoints = new int[strLen];
        int outOffset = 0;
        boolean capitalizeNext = true;
        int index = 0;
        while (index < strLen) {
            int codePoint = str.codePointAt(index);
            if (isDelimiter.test(codePoint)) {
                capitalizeNext = true;
                newCodePoints[outOffset++] = codePoint;
                index += Character.charCount(codePoint);
                continue;
            }
            if (capitalizeNext) {
                int titleCaseCodePoint = Character.toTitleCase(codePoint);
                newCodePoints[outOffset++] = titleCaseCodePoint;
                index += Character.charCount(titleCaseCodePoint);
                capitalizeNext = false;
                continue;
            }
            newCodePoints[outOffset++] = codePoint;
            index += Character.charCount(codePoint);
        }
        return new String(newCodePoints, 0, outOffset);
    }

    private static Predicate<Integer> generateIsDelimiterFunction(char[] delimiters) {
        Predicate<Integer> isDelimiter;
        if (delimiters == null || delimiters.length == 0) {
            isDelimiter = delimiters == null ? Character::isWhitespace : c -> false;
        } else {
            HashSet<Integer> delimiterSet = new HashSet<Integer>();
            for (int index = 0; index < delimiters.length; ++index) {
                delimiterSet.add(Character.codePointAt(delimiters, index));
            }
            isDelimiter = delimiterSet::contains;
        }
        return isDelimiter;
    }
}

