package com.xebialabs.xlrelease.utils

import com.xebialabs.xlrelease.repository.Ids
import com.xebialabs.xlrelease.repository.Ids.{ROOT_FOLDER_ID, SEPARATOR}

case class FolderId(anyPath: String) {
  val path = applicationsToSlash(anyPath)

  def absolute: String = {
    if (isEmpty) ROOT_FOLDER_ID else s"$ROOT_FOLDER_ID$path"
  }

  def id: String = {
    if (isEmpty) "/" else Ids.getName(path)
  }

  def parent: FolderId = if (isEmpty) FolderId.Root else FolderId(Ids.getParentId(path))

  def isEmpty: Boolean = path.stripPrefix(SEPARATOR).isEmpty

  def add(childId: String): FolderId = FolderId(s"$path${FolderId(childId).path}")

  def /(childId: String): FolderId = if (childId != null) add(childId) else this

  def getPath: Array[String] = {
    if (isEmpty) Array.empty[String] else path.split(Ids.SEPARATOR).tail
  }

  @inline
  private def applicationsToSlash(anyPath: String): String = {
    SEPARATOR + anyPath.stripSuffix(SEPARATOR).stripPrefix(ROOT_FOLDER_ID).dropWhile(_ == SEPARATOR.head)
  }
}

object FolderId {
  val Root = FolderId(ROOT_FOLDER_ID)
}
