package com.xebialabs.xlrelease.configuration

import com.xebialabs.xlrelease.configuration.ThemeColor._

object ThemeColors {

  private val blueHexCode = "#3D6C9E"
  private val greenHexCode = "#498500"
  private val redHexCode = "#D61F21"
  private val orangeHexCode = "#FF9E49"
  private val grayHexCode = "#667385"
  private val purpleHexCode = "#991C71"
  private val yellowHexCode = "#EEC511"

  def colorCode(themeColor: ThemeColor): String = themeColor match {
    case BLUE => blueHexCode
    case GREEN => greenHexCode
    case RED => redHexCode
    case ORANGE => orangeHexCode
    case GRAY => grayHexCode
    case PURPLE => purpleHexCode
    case YELLOW => yellowHexCode
  }

  def themeColorFromCode: PartialFunction[String, ThemeColor] = {
    case `blueHexCode` => BLUE
    case `greenHexCode` => GREEN
    case `redHexCode` => RED
    case `orangeHexCode` => ORANGE
    case `grayHexCode` => GRAY
    case `purpleHexCode` => PURPLE
    case `yellowHexCode` => YELLOW
  }

  def themeColorFromOldCode: PartialFunction[String, ThemeColor] = {
    case "#68b749" => BLUE
    case "#FF9E3B" => RED
    case "#DD4B39" => ORANGE
    case "#999999" => GRAY
    case "#991C71" => PURPLE
  }

  def fromOldCodeWithDefaultGreen(oldCode: String): ThemeColor =
    themeColorFromOldCode
      .lift
      .apply(oldCode.toUpperCase)
      .getOrElse(ThemeColor.GREEN)

}
