/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

public class ClassPathResources {
    public static byte[] getBytes(String resourceName) throws IOException {
        try (InputStream in = ClassPathResources.getInputStream(resourceName);){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)in);
            return byArray;
        }
    }

    public static String getString(String resourceName, Charset charset) throws IOException {
        try (InputStream in = ClassPathResources.getInputStream(resourceName);){
            String string = StreamUtils.copyToString((InputStream)in, (Charset)charset);
            return string;
        }
    }

    public static InputStream getInputStream(String resourceName) throws IOException {
        return ClassPathResources.getResource(resourceName).getInputStream();
    }

    private static Resource getResource(String resourceName) {
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        return resourceLoader.getResource(resourceName);
    }
}

