/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.assertions.PlanItemAssertion;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.status.PhaseStatus;
import org.assertj.core.api.Assertions;

public class PhaseAssertion
extends PlanItemAssertion<PhaseAssertion, Phase> {
    protected PhaseAssertion(Phase actual) {
        super(actual, PhaseAssertion.class);
    }

    public PhaseAssertion hasOriginId(String id) {
        this.isNotNull();
        Assertions.assertThat((String)((Phase)this.actual).getOriginId()).isEqualTo(id);
        return this;
    }

    public PhaseAssertion hasStatus(PhaseStatus status) {
        this.isNotNull();
        Assertions.assertThat((Comparable)((Phase)this.actual).getStatus()).isEqualTo((Object)status);
        return this;
    }

    public PhaseAssertion hasTitle(String expectedTitle) {
        this.isNotNull();
        Assertions.assertThat((String)((Phase)this.actual).getTitle()).isEqualTo(expectedTitle);
        return this;
    }

    public PhaseAssertion isCopiedFrom(Phase other) {
        this.isNotNull();
        Assertions.assertThat((Comparable)other).isNotNull();
        this.hasOriginId(other.getId());
        return this;
    }

    public PhaseAssertion isPhaseVersionMostRecent() {
        this.isNotNull();
        Assertions.assertThat((boolean)((Phase)this.actual).isPhaseCopied()).isFalse();
        return this;
    }

    public PhaseAssertion isPhaseVersionOriginal() {
        this.isNotNull();
        Assertions.assertThat((String)((Phase)this.actual).getOriginId()).isNullOrEmpty();
        return this;
    }

    public PhaseAssertion isNotPhaseVersionOriginal() {
        this.isNotNull();
        Assertions.assertThat((String)((Phase)this.actual).getOriginId()).isNotEmpty();
        return this;
    }

    public PhaseAssertion isCompleted() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.COMPLETED);
        this.hasEndDate();
        return this;
    }

    public PhaseAssertion isInProgress() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.IN_PROGRESS).hasNoEndDate();
        return this;
    }

    public PhaseAssertion isFailed() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.FAILED);
        return this;
    }

    public PhaseAssertion isAborted() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.ABORTED);
        return this;
    }

    public PhaseAssertion isPlanned() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.PLANNED);
        return this;
    }

    public PhaseAssertion isFailing() {
        ((PhaseAssertion)this.isNotNull()).hasStatus(PhaseStatus.FAILING);
        return this;
    }
}

