package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;

public class VariableAssertion extends AbstractAssert<VariableAssertion, Variable> {

    protected VariableAssertion(Variable actual) {
        super(actual, VariableAssertion.class);
    }

    public VariableAssertion hasValue(String value) {
        isNotNull();
        isInstanceOf(StringVariable.class);
        Assertions.assertThat(((StringVariable) actual).getValue()).isEqualTo(value);
        return this;
    }

    public VariableAssertion hasPassword(String value) {
        isNotNull();
        isInstanceOf(PasswordStringVariable.class);
        Assertions.assertThat(((PasswordStringVariable) actual).getValue()).isEqualTo(value);
        return this;
    }

    public VariableAssertion hasNoValue() {
        isNotNull();
        Assertions.assertThat(actual.getValue()).isNull();
        return this;
    }

    public VariableAssertion hasKey(String key) {
        isNotNull();
        Assertions.assertThat(actual.getKey()).isEqualTo(key);
        return this;
    }

    public VariableAssertion hasType(Class<? extends Variable> type) {
        isNotNull();
        Assertions.assertThat(actual).isExactlyInstanceOf(type);
        return this;
    }

    public VariableAssertion hasId(String id) {
        isNotNull();
        Assertions.assertThat(actual.getId()).isEqualTo(id);
        return this;
    }

    public VariableAssertion hasLabel(String label) {
        isNotNull();
        Assertions.assertThat(actual.getLabel()).isEqualTo(label);
        return this;
    }

    public VariableAssertion isRequired() {
        isNotNull();
        Assertions.assertThat(actual.getRequiresValue()).isTrue();
        return this;
    }

    public VariableAssertion isNotRequired() {
        isNotNull();
        Assertions.assertThat(actual.getRequiresValue()).isFalse();
        return this;
    }
}
