package com.xebialabs.xlrelease

import com.xebialabs.xlrelease.rules.LoginRule
import org.springframework.security.core.Authentication
import org.springframework.security.core.context.SecurityContextHolder

trait TestAuthentication {

  def withAuthentication[T](auth: Authentication)(t: => T): T = {
    val origAuth = SecurityContextHolder.getContext.getAuthentication
    SecurityContextHolder.getContext.setAuthentication(auth)
    try {
      t
    } finally {
      SecurityContextHolder.getContext.setAuthentication(origAuth)
    }
  }

  protected def asAdmin[T](block: => T): T = {
    val auth = LoginRule.loginWithRoleAdmin("admin").getAuthentication
    withAuthentication(auth) {
      block
    }
  }
}
