package com.xebialabs.xlrelease.rules;

import java.util.ArrayList;
import java.util.List;
import org.junit.rules.ExternalResource;

import com.xebialabs.xlrelease.events.EventBus;
import com.xebialabs.xlrelease.events.Subscribe;

public class EventsRule<T> extends ExternalResource {
    private EventBus eventBus;
    private Class<T> eventClass;
    private List<T> capturedEvents = new ArrayList<>();

    public EventsRule(final EventBus eventBus, Class<T> eventClass) {
        this.eventBus = eventBus;
        this.eventClass = eventClass;
    }

    @Override
    public void before() {
        eventBus.register(this);
    }

    @Override
    public void after() {
        eventBus.deregister(this);
    }

    @Subscribe
    public void eventCaptured(T event) {
        if (eventClass.isInstance(event)) {
            capturedEvents.add(event);
        }
    }

    public List<T> getCapturedEvents() {
        return capturedEvents;
    }

}
