package com.xebialabs.xlrelease.matchers.mockito

import com.xebialabs.xlrelease.domain.Release
import org.hamcrest.{BaseMatcher, Description}

object CiMatchers {

  /**
   * Checks that passed object is release with appropriate ID
   */
  def isReleaseWithId(id: String) =
    new BaseMatcher[Release]() {
      override def matches(item: scala.Any): Boolean = item match {
        case r: Release if r.getId == id => true
        case _ => false
      }

      override def describeTo(description: Description): Unit = {
        description
          .appendText("Expected release with ID: ")
          .appendValue(id)
          .appendText(" got ")
      }
    }

}
