package com.xebialabs.xlrelease.assertions;

import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

import com.xebialabs.xlrelease.domain.Team;

import static com.xebialabs.xlrelease.security.XLReleasePermissions.VIEW_RELEASE;

public class TeamListAssertion extends ListAssert<Team> {

    protected TeamListAssertion(List<Team> actual) {
        super(actual);
    }


    public TeamListAssertion containsOnlyMemberViewers(String... members){
        isNotNull();
        Assertions.assertThat(getMembersViewers()).containsOnly(members);
        return this;
    }

    public TeamListAssertion containsOnlyRoleViewers(String... roles){
        isNotNull();
        Assertions.assertThat(getRoleViewers()).containsOnly(roles);
        return this;
    }


    private List<String> getRoleViewers() {
        return actual.stream()
                .filter(team -> team.getPermissions().contains(VIEW_RELEASE.getPermissionName()))
                .flatMap(team -> team.getRoles().stream()).collect(Collectors.toList());
    }

    private List<String> getMembersViewers() {
        return actual.stream()
                .filter(team -> team.getPermissions().contains(VIEW_RELEASE.getPermissionName()))
                .flatMap(team -> team.getMembers().stream()).collect(Collectors.toList());
    }
}
