package com.xebialabs.xlrelease.sugar

import org.mockito.invocation.InvocationOnMock
import org.mockito.stubbing.Answer

import scala.language.implicitConversions

trait AnswerSugar {

  implicit def toAnswer[T](f: () => T): Answer[T] = new Answer[T] {
    override def answer(invocation: InvocationOnMock): T = f()
  }

  implicit def toAnswerWithArguments[T](f: (InvocationOnMock) => T): Answer[T] = new Answer[T] {
    override def answer(invocation: InvocationOnMock): T = f(invocation)
  }

}
