/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.assertions;

import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;

public class TeamListAssertion
extends ListAssert<Team> {
    protected TeamListAssertion(List<Team> actual) {
        super(actual);
    }

    public TeamListAssertion containsOnlyMemberViewers(String ... members) {
        this.isNotNull();
        Assertions.assertThat(this.getMembersViewers()).containsOnly((Object[])members);
        return this;
    }

    public TeamListAssertion containsOnlyRoleViewers(String ... roles) {
        this.isNotNull();
        Assertions.assertThat(this.getRoleViewers()).containsOnly((Object[])roles);
        return this;
    }

    private List<String> getRoleViewers() {
        return ((List)this.actual).stream().filter(team -> team.getPermissions().contains(XLReleasePermissions.VIEW_RELEASE.getPermissionName())).flatMap(team -> team.getRoles().stream()).collect(Collectors.toList());
    }

    private List<String> getMembersViewers() {
        return ((List)this.actual).stream().filter(team -> team.getPermissions().contains(XLReleasePermissions.VIEW_RELEASE.getPermissionName())).flatMap(team -> team.getMembers().stream()).collect(Collectors.toList());
    }
}

