/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.authority.TenantAuthority;
import com.xebialabs.xlrelease.utils.TenantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class LoginRule
extends ExternalResource {
    private static final String GLOBAL_SECURITY_ALIAS = "global";
    private static final String DEFAULT_PASSWORD = "password";
    private final String username;
    private final String password;
    private List<String> authorities = new ArrayList<String>();

    private LoginRule(String username, String password, String ... authorities) {
        this.username = username;
        this.password = password;
        Collections.addAll(this.authorities, authorities);
    }

    public static LoginRule loginWith(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, new String[0]);
    }

    public static LoginRule loginWithRoleAdmin(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, "ROLE_ADMIN");
    }

    public void logout() {
        Permissions.clearSecurityContext();
    }

    public void before() {
        SecurityContext context = SecurityContextHolder.createEmptyContext();
        context.setAuthentication(this.getAuthentication());
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    public Authentication getAuthentication() {
        List grantedAuthorities = AuthorityUtils.createAuthorityList(this.authorities);
        grantedAuthorities.add(new TenantAuthority(TenantContext.SYSTEM_TENANT_ID()));
        return new TestingAuthenticationToken((Object)this.username, (Object)this.password, (Collection)grantedAuthorities);
    }

    public void after() {
        Permissions.clearSecurityContext();
    }

    public static void grantAdminPermissionTo(String username, PermissionEditor permissionEditor, RoleService roleService) {
        LoginRule.grantGlobalPermissionsTo(Set.of(username), Collections.singleton(PlatformPermissions.ADMIN), "RoleWithAdminPermission", permissionEditor, roleService);
    }

    public static void grantGlobalPermissionsTo(String username, Set<Permission> permissions, PermissionEditor permissionEditor, RoleService roleService) {
        LoginRule.grantGlobalPermissionsTo(Set.of(username), permissions, "TestRoleForUser" + username, permissionEditor, roleService);
    }

    public static void grantGlobalPermissionsTo(String username, Set<Permission> permissions, String roleName, PermissionEditor permissionEditor, RoleService roleService) {
        LoginRule.grantGlobalPermissionsTo(Set.of(username), permissions, roleName, permissionEditor, roleService);
    }

    public static void grantGlobalPermissionsTo(Set<String> usernames, Set<Permission> permissions, String roleName, PermissionEditor permissionEditor, RoleService roleService) {
        permissions.forEach(permission -> {
            assert (permission.getLevel() == PermissionHandler.Level.GLOBAL || permission.getLevel() == PermissionHandler.Level.BOTH);
        });
        Role roleWithPermission = new Role(String.valueOf(roleService.getRoles().size()), roleName);
        roleWithPermission.getPrincipals().addAll(usernames);
        HashMap<Role, Set<Permission>> rolePermission = new HashMap<Role, Set<Permission>>();
        rolePermission.put(roleWithPermission, permissions);
        roleService.writeRoleAssignments(Collections.singletonList(roleWithPermission));
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermission);
    }

    public static void addUserToRole(String username, String roleName, RoleService roleService) {
        Role role = new Role(null, roleName);
        role.getPrincipals().add(username);
        List existingRoles = roleService.readRoleAssignments();
        existingRoles.add(role);
        roleService.writeRoleAssignments(existingRoles);
    }

    public static void clearPermissions(PermissionEditor permissionEditor, RoleService roleService) {
        HashMap rolePermission = new HashMap();
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermission);
        roleService.writeRoleAssignments(Collections.emptyList());
    }
}

