package com.xebialabs.xlrelease.assertions;

import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

import com.xebialabs.xlrelease.domain.Attachment;

public class AttachmentAssertion extends AbstractAssert<AttachmentAssertion, Attachment> {

    protected AttachmentAssertion(final Attachment actual) {
        super(actual, AttachmentAssertion.class);
    }

    public AttachmentAssertion hasId(String id) {
        isNotNull();
        Assertions.assertThat(actual.getId()).isEqualTo(id);
        return this;
    }
}
