package com.xebialabs.xlrelease

import com.xebialabs.deployit.booter.local.LocalBooter
import com.xebialabs.deployit.util.DeployitKeys._
import com.xebialabs.deployit.util.PasswordEncrypter
import com.xebialabs.xlrelease.sugar.AnswerSugar
import grizzled.slf4j.Logging
import org.junit.runner.RunWith
import org.scalatest.funspec.AnyFunSpecLike
import org.scalatest.matchers.should.Matchers
import org.scalatest.{BeforeAndAfterAll, BeforeAndAfterEach}
import org.scalatestplus.junit.JUnitRunner
import org.scalatestplus.mockito.MockitoSugar

@RunWith(classOf[JUnitRunner])
abstract class XLReleaseScalaTest extends XLReleaseScalaTestTrait


trait XLReleaseScalaTestTrait
  extends AnyFunSpecLike
    with Matchers
    with BeforeAndAfterAll
    with BeforeAndAfterEach
    with MockitoSugar
    with AnswerSugar
    with Logging
    with TestAuthentication {

  LocalBooter.bootWithoutGlobalContext()
  PasswordEncrypter.init(DEFAULT_PASSWORD_ENCRYPTION_KEY)

}


