/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.rules;

import com.xebialabs.deployit.security.PermissionEditor;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.deployit.security.permission.PermissionHandler;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class LoginRule
extends ExternalResource {
    private static final String GLOBAL_SECURITY_ALIAS = "global";
    private static final String DEFAULT_PASSWORD = "password";
    private final String username;
    private final String password;
    private List<String> authorities;

    private LoginRule(String username, String password, String ... authorities) {
        this.username = username;
        this.password = password;
        this.authorities = new ArrayList<String>();
        Collections.addAll(this.authorities, authorities);
    }

    public static LoginRule loginWith(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, new String[0]);
    }

    public static LoginRule loginWithRoleAdmin(String username) {
        return new LoginRule(username, DEFAULT_PASSWORD, "ROLE_ADMIN");
    }

    public void logout() {
        Permissions.clearSecurityContext();
    }

    public void before() {
        SecurityContextImpl context = new SecurityContextImpl();
        context.setAuthentication(this.getAuthentication());
        SecurityContextHolder.setContext((SecurityContext)context);
    }

    public Authentication getAuthentication() {
        return new TestingAuthenticationToken((Object)this.username, (Object)this.password, this.authorities.toArray(new String[this.authorities.size()]));
    }

    public void after() {
        Permissions.clearSecurityContext();
    }

    public static void grantAdminPermissionTo(String username, PermissionEditor permissionEditor, RoleService roleService) {
        Role roleWithAdminPermission = new Role(String.valueOf(roleService.getRoles().size()), "RoleWithAdminPermission");
        roleWithAdminPermission.getPrincipals().add(username);
        HashMap<Role, Set<Permission>> rolePermission = new HashMap<Role, Set<Permission>>();
        rolePermission.put(roleWithAdminPermission, Collections.singleton(PlatformPermissions.ADMIN));
        roleService.writeRoleAssignments(Collections.singletonList(roleWithAdminPermission));
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermission);
    }

    public static void grantGlobalPermissionsTo(String username, Set<Permission> permissions, PermissionEditor permissionEditor, RoleService roleService) {
        permissions.forEach(permission -> {
            assert (permission.getLevel() == PermissionHandler.Level.GLOBAL);
        });
        Role roleWithPermission = new Role(String.valueOf(roleService.getRoles().size()), "TestRoleForUser" + username);
        roleWithPermission.getPrincipals().add(username);
        HashMap<Role, Set<Permission>> rolePermission = new HashMap<Role, Set<Permission>>();
        rolePermission.put(roleWithPermission, permissions);
        roleService.writeRoleAssignments(Collections.singletonList(roleWithPermission));
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermission);
    }

    public static void addUserToRole(String username, String roleName, RoleService roleService) {
        Role role = new Role(null, roleName);
        role.getPrincipals().add(username);
        List existingRoles = roleService.readRoleAssignments();
        existingRoles.add(role);
        roleService.writeRoleAssignments(existingRoles);
    }

    public static void clearPermissions(PermissionEditor permissionEditor, RoleService roleService) {
        HashMap rolePermission = new HashMap();
        permissionEditor.editPermissions(GLOBAL_SECURITY_ALIAS, rolePermission);
        roleService.writeRoleAssignments(Collections.emptyList());
    }
}

