package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.folder.Folder

import scala.jdk.CollectionConverters._

object FolderBuilder {
  def newFolder: FolderBuilder = new FolderBuilder
}

class FolderBuilder {
  private var id: String = _
  private var title: String = _
  private var children: Set[Folder] = Set()

  def withId(id: String) = {
    this.id = id
    this
  }

  def withTitle(title: String) = {
    this.title = title
    this
  }

  def withChildren(children: Set[Folder]) = {
    this.children = children
    this
  }

  def build: Folder = {
    val folder: Folder = Type.valueOf(classOf[Folder]).getDescriptor.newInstance(id)
    folder.setTitle(title)
    folder.setChildren(children.asJava)
    folder
  }
}
