package com.xebialabs.xlrelease.domain.utils;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;

import com.xebialabs.xlrelease.domain.Release;

public class ReleaseSoftReference {
    private SoftReference<Release> ref;
    private Supplier<Release> supplier;
    private String releaseId;

    public ReleaseSoftReference(Release release, Supplier<Release> supplier) {
        ref = new SoftReference<>(release);
        if (null != release) {
            releaseId = release.getId();
        }
        this.supplier = supplier;
    }

    public Release get() {
        Release release = ref.get();
        if (release == null) {
            release = supplier.get();
            ref = new SoftReference<>(release);
        }
        return release;
    }

    public Release getIfPresent() {
        return ref.get();
    }

    public void clear() {
        ref.clear();
    }

    public String getReleaseId() {
        return releaseId;
    }


}
