package com.xebialabs.xlrelease.builder

import com.xebialabs.deployit.plugin.api.reflect.Type
import com.xebialabs.xlrelease.domain.Configuration
import com.xebialabs.xlrelease.domain.folder.Folder

import java.util.UUID
import scala.jdk.CollectionConverters._

case class ConfigurationBuilder(
                                 configType: Type,
                                 id: String = null,
                                 title: String = null,
                                 folderId: String = null,
                                 properties: Map[String, Object] = Map.empty,
                                 variableMapping: Map[String, String] = Map.empty
                               ) {
  def withId(id: String): ConfigurationBuilder = this.copy(id = id)

  def withTitle(title: String): ConfigurationBuilder = this.copy(title = title)

  def withFolder(folder: Folder): ConfigurationBuilder = this.copy(folderId = folder.getId)

  def withFolderId(folderId: String): ConfigurationBuilder = this.copy(folderId = folderId)

  def withProperty(propertyName: String, propertyValue: Object): ConfigurationBuilder = this.copy(properties = properties + (propertyName -> propertyValue))

  def withVariableMapping(map: Map[String, String]): ConfigurationBuilder = {
    this.copy(variableMapping = map)
  }

  def build[T <: Configuration]: T = {
    val instance = configType.getDescriptor.newInstance(id).asInstanceOf[T]
    if (null == id) {
      instance.setId(s"Configuration/Custom/Configuration${UUID.randomUUID().toString}")
    }
    instance.setTitle(title)
    instance.setFolderId(folderId)
    for ((propName, propValue) <- properties) {
      instance.setProperty(propName, propValue)
    }
    instance.setVariableMapping(variableMapping.asJava)
    instance
  }
}

object ConfigurationBuilder {
  def newConfiguration(configType: String): ConfigurationBuilder = {
    new ConfigurationBuilder(Type.valueOf(configType))
  }
}
