package com.xebialabs.xlrelease.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import com.xebialabs.xlrelease.domain.CreateReleaseTask;
import com.xebialabs.xlrelease.domain.variables.Variable;

import static com.google.common.collect.Lists.newArrayList;

public class CreateReleaseTaskBuilder extends TaskBuilder<CreateReleaseTask, CreateReleaseTaskBuilder> {
    private String newReleaseTitle;
    private String templateId;
    private String folderId;
    private List<Variable> variables = new ArrayList<>();
    private String createdReleaseId;
    private boolean startRelease;
    private Set<String> releaseTags = new HashSet<>();

    public CreateReleaseTaskBuilder withNewReleaseTitle(String newReleaseTitle) {
        this.newReleaseTitle = newReleaseTitle;
        return this;
    }

    public CreateReleaseTaskBuilder withTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public CreateReleaseTaskBuilder withFolderId(String folderId) {
        this.folderId = folderId;
        return this;
    }

    public CreateReleaseTaskBuilder withVariables(List<Variable> variables) {
        this.variables = variables;
        return this;
    }

    public CreateReleaseTaskBuilder withVariables(Variable... variables) {
        return withVariables(newArrayList(variables));
    }

    public CreateReleaseTaskBuilder withCreatedReleaseId(String createdReleaseId) {
        this.createdReleaseId = createdReleaseId;
        return this;
    }

    public CreateReleaseTaskBuilder withStartRelease(boolean startRelease) {
        this.startRelease = startRelease;
        return this;
    }

    public CreateReleaseTaskBuilder withReleaseTags(Set<String> releaseTags) {
        this.releaseTags = releaseTags;
        return this;
    }

    public CreateReleaseTaskBuilder withReleaseTags(String... releaseTags) {
        this.releaseTags = Stream.of(releaseTags).collect(Collectors.toSet());
        return this;
    }

    @Override
    protected void setFields(CreateReleaseTask task) {
        super.setFields(task);
        task.setNewReleaseTitle(newReleaseTitle);
        task.setTemplateId(templateId);
        task.setFolderId(folderId);
        task.setTemplateVariables(variables);
        task.setCreatedReleaseId(createdReleaseId);
        task.setStartRelease(startRelease);
        task.setReleaseTags(releaseTags);
    }

    @Override
    public CreateReleaseTask build() {
        CreateReleaseTask task = new CreateReleaseTask().getType().getDescriptor().newInstance("dummy");
        setFields(task);
        return task;
    }
}
