/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Team;
import java.util.List;

public class TeamBuilder {
    private String id;
    private String teamName;
    private List<String> members = Lists.newArrayList();
    private List<String> roles = Lists.newArrayList();
    private List<String> permissions = Lists.newArrayList();

    public static TeamBuilder newTeam() {
        return new TeamBuilder();
    }

    public TeamBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public TeamBuilder withTeamName(String teamName) {
        this.teamName = teamName;
        return this;
    }

    public TeamBuilder withMembers(String ... members) {
        return this.withMembers(Lists.newArrayList((Object[])members));
    }

    public TeamBuilder withMembers(List<String> members) {
        this.members = members;
        return this;
    }

    public TeamBuilder withRoles(String ... roles) {
        return this.withRoles(Lists.newArrayList((Object[])roles));
    }

    public TeamBuilder withRoles(List<String> roles) {
        this.roles = roles;
        return this;
    }

    public TeamBuilder withPermissions(String ... permissions) {
        return this.withPermissions(Lists.newArrayList((Object[])permissions));
    }

    public TeamBuilder withPermissions(List<String> permissions) {
        this.permissions = permissions;
        return this;
    }

    public Team build() {
        Team team = (Team)new Team().getType().getDescriptor().newInstance(this.id);
        team.setTeamName(this.teamName);
        team.setMembers(this.members);
        team.setRoles(this.roles);
        team.setPermissions(this.permissions);
        return team;
    }
}

