/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import com.xebialabs.xlrelease.domain.Task;
import java.lang.ref.SoftReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSoftReference<U extends Task> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSoftReference.class);
    private SoftReference<U> softReference;
    private String taskId;
    private String executionId;
    private Supplier<U> supplier;
    private boolean isAbortScriptInProgress;

    public TaskSoftReference(U task, Supplier<U> supplier) {
        this.softReference = new SoftReference<U>(task);
        this.taskId = task.getId();
        this.executionId = ((Task)task).getExecutionId();
        this.supplier = supplier;
        this.isAbortScriptInProgress = ((Task)task).isAbortScriptInProgress();
    }

    public U get() {
        Task task = (Task)this.softReference.get();
        if (task == null) {
            LOGGER.debug("Reference GCed, going to read from database {}", (Object)this.taskId);
            task = (Task)this.supplier.get();
            this.softReference = new SoftReference<Task>(task);
        } else {
            LOGGER.debug("Reference survived {}", (Object)this.taskId);
        }
        return (U)task;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean isAbortScriptInProgress() {
        return this.isAbortScriptInProgress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskSoftReference that = (TaskSoftReference)o;
        if (this.isAbortScriptInProgress != that.isAbortScriptInProgress) {
            return false;
        }
        return this.taskId != null ? this.taskId.equals(that.taskId) : that.taskId == null;
    }

    public int hashCode() {
        int result = this.taskId != null ? this.taskId.hashCode() : 0;
        result = 31 * result + (this.isAbortScriptInProgress ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TaskSoftReference{softReference=" + this.softReference + ", taskId='" + this.taskId + '\'' + ", executionId='" + this.executionId + '\'' + ", supplier=" + this.supplier + ", isAbortScriptInProgress=" + this.isAbortScriptInProgress + '}';
    }
}

