/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.utils;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.Release;
import java.util.function.Supplier;

public class OptionallyDecoratedReleaseSupplier {
    private String releaseId;
    private Supplier<Release> decoratedCache;
    private Supplier<Release> decoratedSupplier;
    private Supplier<Release> nonDecoratedSupplier;

    public OptionallyDecoratedReleaseSupplier(String releaseId, Supplier<Release> decoratedCache, Supplier<Release> decoratedSupplier, Supplier<Release> nonDecoratedSupplier) {
        this.releaseId = releaseId;
        this.decoratedCache = decoratedCache;
        this.decoratedSupplier = decoratedSupplier;
        this.nonDecoratedSupplier = nonDecoratedSupplier;
    }

    public Release getDecorated() {
        Release release = this.decoratedCache.get();
        if (release == null) {
            release = this.decoratedSupplier.get();
        }
        return release;
    }

    public Release getNonDecorated() {
        Release release = this.decoratedCache.get();
        if (release == null) {
            release = this.nonDecoratedSupplier.get();
        }
        return release;
    }

    public static OptionallyDecoratedReleaseSupplier ofDecoratedRelease(Release release) {
        Checks.checkNotNull((Object)release, (String)"Release");
        return new OptionallyDecoratedReleaseSupplier(release.getId(), () -> release, null, null);
    }

    public String toString() {
        return "OptionallyDecoratedReleaseSupplier{releaseId='" + this.releaseId + '\'' + '}';
    }
}

