/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Stage;
import com.xebialabs.xlrelease.domain.delivery.condition.ConditionGroup;
import com.xebialabs.xlrelease.domain.utils.DeliveryUtils;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Metadata(versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class Transition
extends BaseConfigurationItem {
    @Property
    private String title;
    @Property(asContainment=true)
    private Stage stage;
    @Property(asContainment=true, description="Conditions for the transition to execute automatically.")
    private List<Condition> conditions = new ArrayList<Condition>();
    @Property(label="Is automated?", defaultValue="true", description="Are the automated conditions on the transition enabled")
    private boolean automated = true;

    public Transition() {
    }

    public Transition(String title) {
        this.title = title;
    }

    @PublicApiMember
    public <C extends Condition> List<C> getConditionsOfType(Class<C> conditionClass) {
        Type conditionType = Type.valueOf(conditionClass);
        return this.getAllConditions().stream().filter(condition -> condition.getType().instanceOf(conditionType)).map(conditionClass::cast).collect(Collectors.toList());
    }

    public List<Condition> getAllConditions() {
        return this.getConditions().stream().flatMap(child -> child.getAllConditions().stream()).collect(Collectors.toList());
    }

    public List<Condition> getLeafConditions() {
        return this.getConditions().stream().flatMap(child -> child.getLeafConditions().stream()).collect(Collectors.toList());
    }

    public void addCondition(Condition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(condition);
    }

    public Condition getRootCondition() {
        ConditionGroup root = new ConditionGroup();
        root.setId("ROOT");
        root.setOperator(ConditionGroup.Operator.OR);
        root.setConditions(this.conditions);
        return root;
    }

    public Condition getConditionById(String conditionId) {
        return this.findConditionById(conditionId).orElseThrow(() -> new LogFriendlyNotFoundException("Condition '%s' does not exist in transition '%s'", new Object[]{conditionId, this.title}));
    }

    public Optional<Condition> findConditionById(String conditionId) {
        String conditionBaseId = Ids.getName((String)conditionId);
        return this.getAllConditions().stream().filter(condition -> Ids.getName((String)condition.getId()).equals(conditionBaseId)).findFirst();
    }

    public void checkRestrictions() {
        Checks.checkArgument((this.conditions.size() <= 1 ? 1 : 0) != 0, (String)"Conditions can contain only one root condition group", (Object[])new Object[0]);
        this.conditions.forEach(condition -> {
            Checks.checkArgument((boolean)DeliveryUtils.isConditionGroup(condition), (String)"The root condition must be a condition group", (Object[])new Object[0]);
            ConditionGroup rootGroup = (ConditionGroup)((Object)condition);
            Checks.checkNotNull((Object)((Object)rootGroup.getOperator()), (String)"Root group operator");
            rootGroup.getConditions().forEach(nestedCondition -> {
                Checks.checkArgument((boolean)DeliveryUtils.isConditionGroup(nestedCondition), (String)"Root group can only contain other nested condition groups", (Object[])new Object[0]);
                ConditionGroup nestedGroup = (ConditionGroup)((Object)((Object)nestedCondition));
                Checks.checkNotNull((Object)((Object)nestedGroup.getOperator()), (String)"Nested group operator");
                Checks.checkArgument((!rootGroup.getOperator().equals((Object)nestedGroup.getOperator()) ? 1 : 0) != 0, (String)"Nested group operator must not equal the root group operator", (Object[])new Object[0]);
                nestedGroup.getConditions().forEach(concreteCondition -> Checks.checkArgument((!DeliveryUtils.isConditionGroup(concreteCondition) ? 1 : 0) != 0, (String)"Nested groups can only contain concrete conditions", (Object[])new Object[0]));
            });
        });
    }

    @PublicApiMember
    public String getTitle() {
        return this.title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public Stage getStage() {
        return this.stage;
    }

    @PublicApiMember
    public void setStage(Stage stage) {
        this.stage = stage;
    }

    @PublicApiMember
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @PublicApiMember
    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    @PublicApiMember
    public boolean isAutomated() {
        return this.automated;
    }

    @PublicApiMember
    public void setAutomated(boolean automated) {
        this.automated = automated;
    }
}

