/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.variable;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.domain.variables.reference.VariableReference;
import com.xebialabs.xlrelease.utils.DateVariableUtils;
import com.xebialabs.xlrelease.variable.VariableFactory$;
import com.xebialabs.xlrelease.variable.VariablesGraphResolver$;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VariableHelper$ {
    public static final VariableHelper$ MODULE$ = new VariableHelper$();
    private static ObjectMapper jsonWriter;
    private static final String VARIABLE_PATTERN;
    private static final Pattern VARIABLE_NAME_PATTERN;
    private static final Pattern ONLY_ONE_VARIABLE_NAME_PATTERN;
    private static final Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN;
    private static final Pattern GLOBAL_VARIABLE_NAME_PATTERN;
    private static final Pattern FOLDER_VARIABLE_NAME_PATTERN;
    private static volatile boolean bitmap$0;

    static {
        VARIABLE_PATTERN = "\\$\\{\\s*([^}]*[^} ])\\s*\\}";
        VARIABLE_NAME_PATTERN = Pattern.compile(MODULE$.VARIABLE_PATTERN());
        ONLY_ONE_VARIABLE_NAME_PATTERN = Pattern.compile("^\\$\\{([^}]+)\\}$");
        CI_PROPERTY_VARIABLE_NAME_PATTERN = Pattern.compile("^release\\..*$", 2);
        GLOBAL_VARIABLE_NAME_PATTERN = Pattern.compile("^global\\..*$", 2);
        FOLDER_VARIABLE_NAME_PATTERN = Pattern.compile("^folder\\..*$", 2);
    }

    private String VARIABLE_PATTERN() {
        return VARIABLE_PATTERN;
    }

    private Pattern VARIABLE_NAME_PATTERN() {
        return VARIABLE_NAME_PATTERN;
    }

    private Pattern ONLY_ONE_VARIABLE_NAME_PATTERN() {
        return ONLY_ONE_VARIABLE_NAME_PATTERN;
    }

    private Pattern CI_PROPERTY_VARIABLE_NAME_PATTERN() {
        return CI_PROPERTY_VARIABLE_NAME_PATTERN;
    }

    private Pattern GLOBAL_VARIABLE_NAME_PATTERN() {
        return GLOBAL_VARIABLE_NAME_PATTERN;
    }

    private Pattern FOLDER_VARIABLE_NAME_PATTERN() {
        return FOLDER_VARIABLE_NAME_PATTERN;
    }

    public String replaceAll(String raw, java.util.Map<String, String> replacements) {
        return (String)Option$.MODULE$.apply((Object)raw).map((Function1 & Serializable)x$1 -> (String)CollectionConverters$.MODULE$.SetHasAsScala(replacements.entrySet()).asScala().foldLeft(x$1, (Function2 & Serializable)(s, entry) -> {
            Matcher matcher = MODULE$.VARIABLE_NAME_PATTERN().matcher((CharSequence)entry.getKey());
            return matcher.matches() && entry.getValue() != null ? s.replaceAll(new StringBuilder(12).append("\\$\\{\\s*").append(Pattern.quote(matcher.group(1))).append("\\s*\\}").toString(), Matcher.quoteReplacement((String)entry.getValue())) : (entry.getValue() != null ? s.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()) : s);
        })).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String replaceAll(String raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (String)Option$.MODULE$.apply((Object)this.replaceAll(raw, CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(replacements).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$replaceAll$3(x$2)))).asJava())).map((Function1 & Serializable)replaced -> {
            java.util.Set<String> remainingVariables = MODULE$.collectVariables(replaced);
            unresolvedVariables.addAll(remainingVariables);
            return freezeEvenIfUnresolved ? (String)CollectionConverters$.MODULE$.SetHasAsScala(remainingVariables).asScala().foldLeft(replaced, (Function2 & Serializable)(s, remainingVariable) -> MODULE$.freezeUnresolvedVariable((String)s, (String)remainingVariable)) : replaced;
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public <T> T replaceAll(T raw, java.util.Map<String, String> replacements, java.util.Set<String> unresolvedVariables, boolean freezeEvenIfUnresolved) {
        return (T)Option$.MODULE$.apply(raw).map((Function1 & Serializable)x0$1 -> {
            Object object;
            Object object2 = x0$1;
            if (object2 instanceof String) {
                String string = (String)object2;
                object = this.replaceInValue$1(string, replacements, unresolvedVariables, freezeEvenIfUnresolved);
            } else if (object2 instanceof java.util.List) {
                Object object3 = object2;
                object = CollectionConverters$.MODULE$.BufferHasAsJava((Buffer)CollectionConverters$.MODULE$.ListHasAsScala((java.util.List)object3).asScala().map((Function1 & Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved))).asJava();
            } else if (object2 instanceof java.util.Set) {
                Object object4 = object2;
                object = CollectionConverters$.MODULE$.MutableSetHasAsJava((scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala((java.util.Set)object4).asScala().map((Function1 & Serializable)value -> this.replaceInValue$1((String)value, replacements, unresolvedVariables, freezeEvenIfUnresolved))).asJava();
            } else if (object2 instanceof java.util.Map) {
                Object object5 = object2;
                object = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala((java.util.Map)object5).asScala().map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.replaceInValue$1((String)t._1(), replacements, unresolvedVariables, freezeEvenIfUnresolved)), (Object)this.replaceInValue$1((String)t._2(), replacements, unresolvedVariables, freezeEvenIfUnresolved)))).asJava();
            } else {
                object = object2;
            }
            return object;
        }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public String safeReplace(String input, String key, String replacement) {
        return input != null ? input.replace(key, replacement) : input;
    }

    public boolean isCiPropertyVariable(String variableName) {
        return this.CI_PROPERTY_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalVariable(String variableName) {
        return this.GLOBAL_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isFolderVariable(String variableName) {
        return this.FOLDER_VARIABLE_NAME_PATTERN().matcher(this.withoutVariableSyntax(variableName)).find();
    }

    public boolean isGlobalOrFolderVariable(String variableName) {
        return this.isGlobalVariable(variableName) || this.isFolderVariable(variableName);
    }

    public java.util.Set<String> collectVariables(Object input) {
        return CollectionConverters$.MODULE$.SetHasAsJava((Set)Option$.MODULE$.apply(input).map((Function1 & Serializable)x0$1 -> {
            scala.collection.immutable.Set set;
            Object object = x0$1;
            if (object instanceof String) {
                String string = (String)object;
                set = MODULE$.collectVariablesFromValue(string);
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                set = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(collection).asScala().flatMap((Function1 & Serializable)value -> MODULE$.collectVariablesFromValue(value))).toSet();
            } else if (object instanceof java.util.Map) {
                java.util.Map map = (java.util.Map)object;
                set = ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(map).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Object k = tuple2._1();
                    Object v = tuple2._2();
                    scala.collection.immutable.Set set = (scala.collection.immutable.Set)MODULE$.collectVariablesFromValue(k).$plus$plus(MODULE$.collectVariablesFromValue(v));
                    return set;
                })).toSet();
            } else {
                set = Predef$.MODULE$.Set().empty();
            }
            return set;
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).asJava();
    }

    private scala.collection.immutable.Set<String> collectVariablesFromValue(Object value) {
        scala.collection.mutable.Set result = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            Matcher matcher = this.VARIABLE_NAME_PATTERN().matcher(string);
            while (matcher.find()) {
                result.add((Object)new StringBuilder(3).append("${").append(matcher.group(1)).append("}").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return result.toSet();
    }

    public boolean containsVariables(String input) {
        return input != null && this.VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String formatVariableIfNeeded(String variableName) {
        return !com.google.common.base.Strings.isNullOrEmpty((String)variableName) && !this.containsOnlyVariable(variableName) ? this.withVariableSyntax(variableName) : variableName;
    }

    public boolean containsOnlyVariable(String input) {
        return !com.google.common.base.Strings.isNullOrEmpty((String)input) && this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(input).find();
    }

    public String withVariableSyntax(String variableName) {
        return new StringBuilder(3).append("${").append(variableName).append("}").toString();
    }

    public String withoutVariableSyntax(String variableKey) {
        String string;
        if (this.containsOnlyVariable(variableKey)) {
            Matcher matcher = this.ONLY_ONE_VARIABLE_NAME_PATTERN().matcher(variableKey);
            matcher.find();
            string = matcher.group(1);
        } else {
            string = variableKey;
        }
        return string;
    }

    public void checkVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkValidity();
    }

    public void checkVariables(java.util.List<Variable> variables) {
        Preconditions.checkNotNull(variables);
        variables.forEach(variable -> MODULE$.checkVariable((Variable)variable));
        Buffer keys = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().map((Function1 & Serializable)x$3 -> x$3.getKey());
        scala.collection.mutable.Set uniqueKeys = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        keys.foreach((Function1 & Serializable)key -> {
            VariableHelper$.$anonfun$checkVariables$3(uniqueKeys, key);
            return BoxedUnit.UNIT;
        });
    }

    public java.util.Map<String, String> getVariableValuesAsStrings(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(vars).asScala().toList(), false);
    }

    public java.util.Map<String, String> getPasswordVariableValuesAsStrings(java.util.List<Variable> vars) {
        return this.getVariableValuesAsStrings((List<Variable>)CollectionConverters$.MODULE$.ListHasAsScala(vars).asScala().toList(), true);
    }

    public java.util.Map<String, PasswordStringVariable> getExternalVariables(java.util.List<Variable> variables) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(variables).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getExternalVariables$1(x$4)))).map((Function1 & Serializable)v -> new Tuple2((Object)v.getKey(), (Object)((PasswordStringVariable)v)))).filter((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getExternalVariables$3(e)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    private java.util.Map<String, String> getVariableValuesAsStrings(List<Variable> variables, boolean passwords) {
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)Map$.MODULE$.apply(((IterableOnceOps)VariablesGraphResolver$.MODULE$.resolveAsStrings((scala.collection.immutable.Set<Variable>)variables.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getVariableValuesAsStrings$1(passwords, x$5))).toSet())._1()).toSeq())).asJava();
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Map<String, Variable> indexByKey(java.util.List<Variable> variables) {
        void var2_2;
        LinkedHashMap m = new LinkedHashMap();
        Option$.MODULE$.apply(variables).foreach((Function1 & Serializable)x$6 -> {
            x$6.forEach(v -> m.put((Object)v.getKey(), v));
            return BoxedUnit.UNIT;
        });
        return CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)var2_2).asJava();
    }

    public void checkVariableIdsAreTheSame(String requestVariableId, String bodyVariableId) {
        String string = bodyVariableId;
        String string2 = requestVariableId;
        Checks.checkArgument((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0, (String)"Request to update variable [%s] contains an object with different ID: [%s]", (Object[])new Object[]{requestVariableId, bodyVariableId});
    }

    public boolean isGlobalVariableId(String id) {
        return id.startsWith("Configuration/variables/global/") || id.startsWith("/Configuration/variables/global/");
    }

    public java.util.List<Variable> fillVariableValues(java.util.List<Variable> target, java.util.List<Variable> source) {
        java.util.Map<String, Variable> sourceVariables = this.indexByKey(source);
        target.forEach(targetVariable -> {
            Variable sourceVariable;
            String key = targetVariable.getKey();
            if (sourceVariables.containsKey(key) && !(sourceVariable = (Variable)sourceVariables.get(key)).isInherited()) {
                if (targetVariable.getType().equals((Object)sourceVariable.getType())) {
                    targetVariable.setUntypedValue(sourceVariable.getValue());
                } else {
                    throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(33).append("Cannot set value of type [").append(sourceVariable.getType()).append("] into ").toString()).append(new StringBuilder(20).append("variable ").append(MODULE$.withVariableSyntax(sourceVariable.getKey())).append(" of type [").append(targetVariable.getType()).append("]").toString()).toString());
                }
            }
        });
        return target;
    }

    public String freezeUnresolvedVariable(String input, String variableName) {
        String string;
        if (this.containsVariables(variableName)) {
            String dollarLessName = variableName.substring(1);
            string = input.replace(variableName, new StringBuilder(2).append("$~").append(dollarLessName).toString());
        } else {
            string = input;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public Variable cloneVariable(Variable variable, String newKey) {
        void var3_3;
        Variable newVar = VariableFactory$.MODULE$.createVariableByValueType(newKey, variable.getValue(), false, false);
        newVar.setId(null);
        newVar.setDescription(variable.getDescription());
        newVar.setLabel(variable.getLabel());
        newVar.setValueProvider(variable.getValueProvider());
        Option$.MODULE$.apply((Object)newVar.getValueProvider()).foreach((Function1 & Serializable)x$7 -> {
            x$7.setId(null);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    public void collectVariablesInScope(java.util.Map<String, Variable> allUsedVariablesMap, java.util.Map<String, Variable> scope, String variableKeyToResolve) {
        block0: {
            Variable variableToResolve;
            if (allUsedVariablesMap.containsKey(variableKeyToResolve) || (variableToResolve = scope.get(variableKeyToResolve)) == null) break block0;
            allUsedVariablesMap.putIfAbsent(variableKeyToResolve, variableToResolve);
            scala.collection.mutable.Set referencedVariableKeys = CollectionConverters$.MODULE$.SetHasAsScala(this.collectVariables(variableToResolve.getValueAsString())).asScala();
            referencedVariableKeys = (scala.collection.mutable.Set)referencedVariableKeys.map((Function1 & Serializable)variableKey -> MODULE$.withoutVariableSyntax((String)variableKey));
            referencedVariableKeys.foreach((Function1 & Serializable)referencedVariableKey -> {
                Object object;
                if (!allUsedVariablesMap.containsKey(referencedVariableKey)) {
                    Variable referencedVariable = (Variable)scope.get(referencedVariableKey);
                    if (referencedVariable != null) {
                        MODULE$.collectVariablesInScope(allUsedVariablesMap, scope, (String)referencedVariableKey);
                        object = allUsedVariablesMap.put((String)referencedVariableKey, referencedVariable);
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
        }
    }

    public java.util.Map<String, PasswordStringVariable> getUsedExternalPasswordVariables(Release release) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.getUsedVariables(release, true)).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$getUsedExternalPasswordVariables$1(x0$1)))).map((Function1 & Serializable)v -> new Tuple2((Object)v.getKey(), (Object)((PasswordStringVariable)v)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public java.util.Map<String, String> getUsedStringVariables(Release release) {
        ArrayList<Variable> variableList = this.getUsedVariables(release, this.getUsedVariables$default$2());
        return this.getVariableValuesAsStrings(variableList);
    }

    private ArrayList<Variable> getUsedVariables(Release release, boolean enablePassword) {
        HashMap allUsedVariablesMap = new HashMap();
        HashMap<String, Variable> scope = this.getAllReleaseVariablesByKeys(release);
        CollectionConverters$.MODULE$.SetHasAsScala(release.collectVariableReferences()).asScala().foreach((Function1 & Serializable)variableReference -> {
            Object object;
            String variableKey = MODULE$.withoutVariableSyntax(variableReference.getKey());
            Variable variable = (Variable)scope.get(variableKey);
            if (variable != null) {
                Variable variable2;
                VariableReference.VariableUsageType variableUsageType = variableReference.getType();
                if (((Object)((Object)VariableReference.VariableUsageType.DEFAULT)).equals((Object)variableUsageType)) {
                    variable2 = allUsedVariablesMap.putIfAbsent(variableKey, variable);
                } else if (((Object)((Object)VariableReference.VariableUsageType.GLOBAL)).equals((Object)variableUsageType)) {
                    MODULE$.collectVariablesInScope(allUsedVariablesMap, scope, variableKey);
                    variable2 = BoxedUnit.UNIT;
                } else if (((Object)((Object)VariableReference.VariableUsageType.FOLDER)).equals((Object)variableUsageType)) {
                    MODULE$.collectVariablesInScope(allUsedVariablesMap, scope, variableKey);
                    variable2 = BoxedUnit.UNIT;
                } else if (((Object)((Object)VariableReference.VariableUsageType.PASSWORD)).equals((Object)variableUsageType)) {
                    BoxedUnit boxedUnit;
                    if (enablePassword) {
                        MODULE$.collectVariablesInScope(allUsedVariablesMap, scope, variableKey);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    variable2 = boxedUnit;
                } else {
                    variable2 = BoxedUnit.UNIT;
                }
                object = variable2;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        ArrayList<Variable> allUsedVariablesList = new ArrayList<Variable>(allUsedVariablesMap.values());
        allUsedVariablesList.addAll(release.getCiPropertyVariables());
        return allUsedVariablesList;
    }

    private boolean getUsedVariables$default$2() {
        return false;
    }

    public java.util.Map<String, String> filterOutBlankStringVariables(java.util.Map<String, String> variables) {
        return CollectionConverters$.MODULE$.MapHasAsJava((Map)((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(variables).asScala().filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)VariableHelper$.$anonfun$filterOutBlankStringVariables$1(entry)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
    }

    public HashMap<String, Variable> getAllReleaseVariablesByKeys(Release release) {
        java.util.Map<String, Variable> releaseVariables = release.getVariablesByKeys();
        java.util.Map globalVariables = release.getGlobalVariables() != null ? release.getGlobalVariables().getVariablesByKeys() : Collections.emptyMap();
        java.util.Map folderVariables = release.getFolderVariables() != null ? release.getFolderVariables().getVariablesByKeys() : Collections.emptyMap();
        HashMap<String, Variable> scope = new HashMap<String, Variable>();
        scope.putAll(releaseVariables);
        scope.putAll(globalVariables);
        scope.putAll(folderVariables);
        return scope;
    }

    private ObjectMapper jsonWriter$lzycompute() {
        VariableHelper$ variableHelper$ = this;
        synchronized (variableHelper$) {
            if (!bitmap$0) {
                jsonWriter = new ObjectMapper();
                bitmap$0 = true;
            }
        }
        return jsonWriter;
    }

    private ObjectMapper jsonWriter() {
        return !bitmap$0 ? this.jsonWriter$lzycompute() : jsonWriter;
    }

    public String toString(Object untyped) {
        String string;
        Object object = untyped;
        if (object instanceof String) {
            String string2;
            string = string2 = (String)object;
        } else if (object instanceof Date) {
            Date date = (Date)object;
            string = DateVariableUtils.printDate((Date)date);
        } else if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            string = this.jsonWriter().writeValueAsString((Object)map);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            string = this.jsonWriter().writeValueAsString((Object)collection);
        } else {
            string = String.valueOf(untyped);
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$replaceAll$3(Tuple2 x$2) {
        return x$2._2() != null;
    }

    private final String replaceInValue$1(String value, java.util.Map replacements$2, java.util.Set unresolvedVariables$2, boolean freezeEvenIfUnresolved$2) {
        return this.replaceAll((Object)value, (java.util.Map<String, String>)replacements$2, (java.util.Set<String>)unresolvedVariables$2, freezeEvenIfUnresolved$2);
    }

    public static final /* synthetic */ void $anonfun$checkVariables$3(scala.collection.mutable.Set uniqueKeys$1, String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((boolean)uniqueKeys$1.add((Object)key), (String)"The variables list contains duplicate keys: '%s'", (Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$getExternalVariables$1(Variable x$4) {
        return x$4 instanceof PasswordStringVariable;
    }

    public static final /* synthetic */ boolean $anonfun$getExternalVariables$3(Tuple2 e) {
        return ((PasswordStringVariable)e._2()).getExternalVariableValue() != null;
    }

    public static final /* synthetic */ boolean $anonfun$getVariableValuesAsStrings$1(boolean passwords$1, Variable x$5) {
        return x$5.isPassword() == passwords$1;
    }

    public static final /* synthetic */ boolean $anonfun$getUsedExternalPasswordVariables$1(Variable x0$1) {
        PasswordStringVariable passwordStringVariable;
        Variable variable = x0$1;
        boolean bl = variable instanceof PasswordStringVariable ? (passwordStringVariable = (PasswordStringVariable)variable).getExternalVariableValue() != null : false;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$filterOutBlankStringVariables$1(Tuple2 entry) {
        return Strings.isNotBlank((String)((String)entry._2()));
    }

    private VariableHelper$() {
    }
}

