package com.xebialabs.xlrelease.configuration;

import java.util.Date;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@PublicApiRef
@Metadata(root = CONFIGURATION, versioned = false)
public class SystemMessageSettings extends BaseConfiguration {
    public static final String SYSTEM_MESSAGE_ID = "Configuration/settings/SystemMessageSettings";

    @Property(required = false, label = "Is system message enabled")
    private boolean enabled;

    @Property(required = false, label = "System message")
    private String message;

    @Property(required = false, label = "Is system message automatically enable/disable")
    private boolean automated;

    @Property(required = false, label = "Date from which the message will be displayed")
    private Date startDate;

    @Property(required = false, label = "Date till which the message will be displayed")
    private Date endDate;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(final boolean enabled) {
        this.enabled = enabled;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(final String message) {
        this.message = message;
    }

    public boolean isAutomated() {
        return automated;
    }

    public void setAutomated(final boolean automated) {
        this.automated = automated;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(final Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(final Date endDate) {
        this.endDate = endDate;
    }

}
