package com.xebialabs.xlrelease.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class TriggerDataPurgeSettings extends BaseConfiguration {

    public static final String TRIGGER_DATA_PURGE_SETTINGS_ID = "Configuration/settings/TriggerDataPurgeSettings";

    @Property(defaultValue = "false", required = false, label = "Enable purging of trigger data")
    private boolean enabled;

    @Property(defaultValue = "720", required = false, label = "Purge trigger data older than")
    private Integer triggersDataPurgeAgeThreshold; // in hours (30 days default)

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getTriggersDataPurgeAgeThreshold() {
        return triggersDataPurgeAgeThreshold;
    }

    public void setTriggersDataPurgeAgeThreshold(Integer triggersDataPurgeAgeThreshold) {
        this.triggersDataPurgeAgeThreshold = triggersDataPurgeAgeThreshold;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        final TriggerDataPurgeSettings that = (TriggerDataPurgeSettings) o;

        if (isEnabled() != that.isEnabled()) return false;
        return getTriggersDataPurgeAgeThreshold() != null ?
                getTriggersDataPurgeAgeThreshold().equals(that.getTriggersDataPurgeAgeThreshold()) :
                that.getTriggersDataPurgeAgeThreshold() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (isEnabled() ? 1 : 0);
        result = 31 * result + (getTriggersDataPurgeAgeThreshold() != null ?
                getTriggersDataPurgeAgeThreshold().hashCode() : 0);
        return result;
    }

}
