package com.xebialabs.xlrelease.domain;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class Attachment extends BaseConfigurationItem implements SourceArtifact {
    public static final String EXPORT_DIRECTORY = "attachments";

    private OverthereFile file;

    @Property
    private String contentType;

    @Property(isTransient = true)
    private String exportFilename;

    @Property
    private String fileUri;

    public Attachment() {
    }

    public Attachment(OverthereFile file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    @Override
    public OverthereFile getFile() {
        return this.file;
    }

    @Override
    public void setFile(OverthereFile file) {
        this.file = file;
    }

    @Override
    public Set<String> getPlaceholders() {
        return Collections.emptySet();
    }

    @Override
    public void setPlaceholders(Set<String> placeholders) {
    }

    @Override
    public String getTextFileNamesRegex() {
        return "";
    }

    @Override
    public String getExcludeFileNamesRegex() {
        return "";
    }

    @Override
    public Map<String, String> getFileEncodings() {
        return Collections.emptyMap();
    }

    @Override
    public String getChecksum() {
        return "";
    }

    @Override
    public String getFileUri() {
        return fileUri;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    private String buildExportFileName() {
        return EXPORT_DIRECTORY + "/" + getName() + "-" + getFile().getName();
    }

    public String getExportFilename() {
        if (exportFilename == null) {
            exportFilename = buildExportFileName();
        }
        return exportFilename;
    }

    public void setExportFilename(String exportFilename) {
        this.exportFilename = exportFilename;
    }
}
