package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import static com.google.common.base.Preconditions.checkArgument;

public class PythonScriptDefinition extends TaskWithPropertiesDefinition {

    public PythonScriptDefinition(Type type, boolean allowed) {
        super(type, allowed);
        checkArgument(type.getDescriptor().isAssignableTo(PythonScript.class), "The type %s must extend xlrelease.PythonScript", type.getDescriptor().getType());
    }

    public PythonScriptDefinition(Type type) {
        this(type, true);
    }

    public static boolean isScriptDefinition(Type type) {
        return type.getDescriptor().isAssignableTo(PythonScript.class);
    }

}
