package com.xebialabs.xlrelease.domain;

import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.repository.Ids;

import static java.util.stream.Collectors.toList;

public class ReleaseExtension extends BaseConfigurationItem implements VisitableItem {
    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
    }

    public List<UsagePoint> getVariableUsages() {
        return this.getType().getDescriptor().getPropertyDescriptors()
                .stream()
                .map(pd -> new PropertyUsagePoint(this, pd.getName()))
                .collect(toList());
    }
}
