package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;

import static java.lang.Thread.currentThread;

public class ScriptHelper {

    public static final String SCRIPT_LOCATION_PROPERTY = "scriptLocation";
    public static final String ABORT_SCRIPT_LOCATION_PROPERTY = "abortScriptLocation";
    public static final String HIDDEN = "hidden";

    public static String getScript(String scriptProperty, ConfigurationItem configurationItem, String defaultSuffix) throws IOException {
        if (configurationItem.hasProperty(scriptProperty)) {
            String customScriptLocation = configurationItem.getProperty(scriptProperty);
            if (Strings.isNotBlank(customScriptLocation)) {
                return readScript(customScriptLocation);
            }
        }
        return readScript(getDefaultPath(configurationItem.getType(), defaultSuffix));
    }

    public static String getScript(ConfigurationItem configurationItem) throws IOException {
        return getScript(SCRIPT_LOCATION_PROPERTY, configurationItem, "");
    }

    public static String getAbortScript(ConfigurationItem configurationItem) throws IOException {
        return getScript(ABORT_SCRIPT_LOCATION_PROPERTY, configurationItem, ".Abort");
    }

    public static String readScript(String path) throws IOException {
        try (InputStream stream = currentThread().getContextClassLoader().getResourceAsStream(path)) {
            if (null == stream) {
                throw new FileNotFoundException("Script not found: " + path);
            }
            return new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8))
                .lines().collect(Collectors.joining(System.lineSeparator()));
        }
    }

    static String getDefaultPath(Type type, String suffix) {
        // TODO <- default path is wrong for groovy scripts!
        return new StringBuilder(type.getPrefix())
                .append("/")
                .append(type.getName())
                .append(suffix)
                .append(".py")
                .toString();
    }

    static String getDefaultPath(Type type) {
        return getDefaultPath(type, "");
    }

    static String getDefaultAbortPath(Type type) {
        return getDefaultPath(type, ".Abort");
    }
}
