package com.xebialabs.xlrelease.domain;

import java.util.List;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiRef;

import static com.xebialabs.xlrelease.repository.Ids.getParentId;
import static com.xebialabs.xlrelease.utils.CiHelper.rewriteWithNewId;
import static java.util.stream.Collectors.toList;

@PublicApiRef
public interface TaskContainer extends ConfigurationItem {

    List<Task> getTasks();

    void setTasks(List<Task> tasks);

    void addTask(Task task, int position);

    default void replaceTask(Task task) {
        Integer index = getTasks().indexOf(task);
        if (index >= 0) {
            rewriteWithNewId(task, task.getId().replace(getParentId(task.getId()), getId()));
            task.setContainer(this);
            getTasks().set(index, task);
        } else {
            getTasks().forEach(t -> t.replaceTask(task));
        }
    }

    default void replaceTask(Task oldTask, Task newTask) {
        List<Task> newTasks = getTasks().stream().map(t -> {
            if (t.equals(oldTask)) {
                t.setContainer(null);
                newTask.setContainer(this);
                return newTask;
            } else {
                return t;
            }
        }).collect(toList());
        setTasks(newTasks);
    }

    default boolean isLocked() {
        return false;
    }

    String getTitle();

}


