package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum DeliveryStatus {
    TEMPLATE("template"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed");

    private final String value;

    public static final DeliveryStatus[] INACTIVE_STATUSES = new DeliveryStatus[]{COMPLETED};

    DeliveryStatus(String v) {
        value = v;
    }

    public boolean isTemplate() {
        return this == TEMPLATE;
    }

    public String value() {
        return value;
    }
}
