package com.xebialabs.xlrelease.domain.delivery;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

import java.util.HashSet;
import java.util.Set;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class StageTrackedItem extends BaseConfigurationItem {
    @Property
    private String trackedItemId;

    @Property(defaultValue = "NOT_READY")
    private TrackedItemStatus status = TrackedItemStatus.NOT_READY;

    @Property
    private Set<String> releaseIds = new HashSet<>();

    public StageTrackedItem() {

    }

    public StageTrackedItem(final String trackedItemId) {
        this.trackedItemId = trackedItemId;
    }

    public StageTrackedItem(final String trackedItemId, final TrackedItemStatus status) {
        this.trackedItemId = trackedItemId;
        this.status = status;
    }

    // ---

    @PublicApiMember
    public TrackedItemStatus getStatus() {
        return status;
    }

    public void setStatus(final TrackedItemStatus status) {
        this.status = status;
    }

    @PublicApiMember
    public String getTrackedItemId() {
        return trackedItemId;
    }

    public void setTrackedItemId(final String trackedItemId) {
        this.trackedItemId = trackedItemId;
    }

    public boolean addReleaseId(String releaseId) {
        return releaseIds.add(releaseId);
    }

    public void addReleaseIds(final Set<String> releaseIds) {
        this.releaseIds.addAll(releaseIds);
    }

    @PublicApiMember
    public Set<String> getReleaseIds() {
        return releaseIds;
    }
}
