package com.xebialabs.xlrelease.domain.delivery;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(versioned = false)
public class TrackedItem extends BaseConfigurationItem {
    @Property
    private String title;

    @Property
    private Set<String> releaseIds = new HashSet<>();

    @Property
    private boolean descoped = false;

    @Property
    private Date createdDate;

    @Property
    private Date modifiedDate;

    public TrackedItem() {
    }

    public TrackedItem(final String title) {
        this.title = title;
    }

    public boolean addReleaseId(String releaseId) {
        return releaseIds.add(releaseId);
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(String title) {
        this.title = title;
    }

    @PublicApiMember
    public Set<String> getReleaseIds() {
        return releaseIds;
    }

    @PublicApiMember
    public void setReleaseIds(Set<String> releaseIds) {
        this.releaseIds = releaseIds;
    }

    @PublicApiMember
    public boolean isDescoped() {
        return descoped;
    }

    @PublicApiMember
    public void setDescoped(final boolean descoped) {
        this.descoped = descoped;
    }

    @PublicApiMember
    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(final Date createdDate) {
        this.createdDate = createdDate;
    }

    @PublicApiMember
    public Date getModifiedDate() {
        return modifiedDate;
    }

    public void setModifiedDate(final Date modifiedDate) {
        this.modifiedDate = modifiedDate;
        if (this.createdDate == null) {
            this.createdDate = modifiedDate;
        }
    }
}

