package com.xebialabs.xlrelease.domain.notification;

import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;

@PublicApiRef
@ShowOnlyPublicApiMembers
public enum MailPriority {
    High("1", "high"),
    Normal("3", "normal"),
    Low("5", "low");

    private final String priority;

    private final String importance;

    MailPriority(String priority, String importance) {
        this.priority = priority;
        this.importance = importance;
    }

    public String getPriority() {
        return priority;
    }

    public String getImportance() {
        return importance;
    }

    public static MailPriority fromString(String text) {
        for (MailPriority priority : MailPriority.values()) {
            if (priority.getImportance().equalsIgnoreCase(text)) {
                return priority;
            }
        }
        return null;
    }
}
