package com.xebialabs.xlrelease.domain.runner

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.deployit.plugin.api.validation.Range
import com.xebialabs.xlrelease.utils.XLTypes.XLProperty

import java.util
import scala.beans.{BeanProperty, BooleanBeanProperty}
import scala.jdk.CollectionConverters._

@Metadata(label = "Remote job runner", description = "Runs Release jobs in a remote environment")
class RemoteJobRunner extends JobRunner {
  @BeanProperty
  @XLProperty(required = true, password = false, description = "Runner name", readonly = true)
  var runnerName: String = _

  @BeanProperty
  @XLProperty(required = true, password = false, description = "Runner version", readonly = true)
  var version: String = _

  @BooleanBeanProperty
  @XLProperty(defaultValue = "true")
  var enabled: Boolean = true

  @BeanProperty
  @XLProperty(asContainment = true) // nested collections are marked 'asContainment'
  var capabilities: util.Set[String] = new util.HashSet[String]()

  @BeanProperty
  @XLProperty(defaultValue = "4", description = "Capacity is number of parallel jobs")
  @Range(minimum = 1, message = "Runner capacity must be greater than 0.")
  var capacity: Integer = _

  @BooleanBeanProperty
  @XLProperty(defaultValue = "true", description = "Control job data encryption between release and remote runner")
  var encryptJobData: Boolean = true

  @BeanProperty
  @XLProperty(required = false, password = true, description = "Runner public key")
  var publicKey: String = _

  override def start(): Unit = {
    JobRunnerOps.start(this)
  }

  override def stop(): Unit = {
    JobRunnerOps.stop(this)
  }

  override def delete(): Unit = {
    JobRunnerOps.delete(this)
  }

  override def abortJob(jobId: Long): Unit = {
    JobRunnerOps.abortJob(this, jobId)
  }

  override def toString(): String = {
    val runnerCapabilities = getCapabilities().asScala.mkString(",")
    s"${this.getType.toString} [id=$getId, runnerName=$runnerName, version=$version, enabled=$enabled, capacity=$capacity, capabilities=[$runnerCapabilities]]"
  }

}

