package com.xebialabs.xlrelease.domain.udm.reporting;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.facet.TaskReportingRecord;

import static com.xebialabs.xlrelease.domain.Task.CATEGORY_INPUT;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label = "ITSM", description = "Unified Data Model for ITSM")
public class ItsmRecord extends TaskReportingRecord {

    @Property(category = CATEGORY_INPUT, label = "Record number", description = "Unique identifier in ITSM.")
    private String record;

    @Property(category = CATEGORY_INPUT, label = "Record URL", description = "Link to the record in ITSM.")
    private String record_url;

    @Property(category = CATEGORY_INPUT, label = "Record title", description = "Title of the record in ITSM.")
    private String title;

    @Property(category = CATEGORY_INPUT, label = "Status", description = "Status of the record.")
    private String status;

    @Property(category = CATEGORY_INPUT, label = "Priority", description = "Priority of the record.")
    private String priority;

    @Property(category = CATEGORY_INPUT, label = "Record created by", description = "Record created by.")
    private String createdBy;

    @PublicApiMember
    public String getRecord() {
        return record;
    }

    @PublicApiMember
    public void setRecord(final String record) {
        this.record = record;
    }

    @PublicApiMember
    public String getRecord_url() {
        return record_url;
    }

    @PublicApiMember
    public void setRecord_url(final String record_url) {
        this.record_url = record_url;
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    @PublicApiMember
    public String getStatus() {
        return status;
    }

    @PublicApiMember
    public void setStatus(final String status) {
        this.status = status;
    }

    @PublicApiMember
    public String getPriority() {
        return priority;
    }

    @PublicApiMember
    public void setPriority(final String priority) {
        this.priority = priority;
    }

    @PublicApiMember
    public String getCreatedBy() {
        return createdBy;
    }

    @PublicApiMember
    public void setCreatedBy(final String createdBy) {
        this.createdBy = createdBy;
    }
}
