package com.xebialabs.xlrelease.domain.variables;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.utils.VariableContainerUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;
import static com.google.common.collect.Lists.newArrayList;
import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;
import static com.xebialabs.xlrelease.variable.VariableHelper.indexByKey;

@Metadata(description = "Global variables container", root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class GlobalVariables extends BaseConfigurationItem implements InternalMetadata {
    public static final String GLOBAL_VARIABLES = "globalVariables";
    public static final String GLOBAL_VARIABLES_ID = CONFIGURATION.getRootNodeName() + "/variables/global";

    @Property(asContainment = true, required = false, description = "List of global variable CIs")
    private List<Variable> variables = newArrayList();

    public GlobalVariables() {
        setId(GLOBAL_VARIABLES_ID);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return VariableContainerUtils.getVariables(variables);
    }

    public Map<String, Variable> getVariablesByKeys() {
        return indexByKey(variables);
    }

    @PublicApiMember
    public Map<String, String> getStringVariableValues() {
        return VariableHelper.getVariableValuesAsStrings(variables);
    }

    @PublicApiMember
    public Map<String, String> getPasswordVariableValues() {
        return VariableHelper.getPasswordVariableValuesAsStrings(variables);
    }

    public void setVariables(final List<Variable> variables) {
        this.variables = variables;
        VariableContainerUtils.setVariableContainerDefaults(this.variables);
    }

    public Variable addVariable(Variable variable) {
        checkNotNull(variable);
        variable.checkGlobalVariableValidity();
        checkArgument(!getVariablesByKeys().containsKey(variable.getKey()), "A variable already exists by key '%s'", variable.getKey());
        VariableContainerUtils.setVariableContainerDefaults(variable);
        this.variables.add(variable);
        return variable;
    }
}
