package com.xebialabs.xlrelease.domain.variables

import com.xebialabs.deployit.plugin.api.udm.Metadata
import com.xebialabs.xlrelease.domain.ScriptHelper
import org.springframework.util.StringUtils

import scala.beans.BeanProperty

@Metadata(label = "Script value provider", description = "", virtual = true)
abstract class ScriptValueProviderConfiguration extends ValueProviderConfiguration {

  def extension: String

  @BeanProperty
  lazy val script: String = {
    val defaultScriptLocation = s"${this.getType.getPrefix}/${getType.getName}${extension}"
    if (this.hasProperty(ScriptHelper.SCRIPT_LOCATION_PROPERTY)) {
      val customScriptLocation: String = this.getProperty(ScriptHelper.SCRIPT_LOCATION_PROPERTY)
      if (StringUtils.hasText(customScriptLocation)) {
        customScriptLocation
      } else {
        defaultScriptLocation
      }
    } else {
      defaultScriptLocation
    }
  }
}

@Metadata(label = "Groovy script value provider", description = "", virtual = true)
class GroovyProvider extends ScriptValueProviderConfiguration {
  def extension: String = ".groovy"
}

@Metadata(label = "Jython script value provider", description = "", virtual = true)
class JythonProvider extends ScriptValueProviderConfiguration {
  def extension: String = ".py"
}
