package com.xebialabs.xlrelease.risk.configuration;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false, description = "Configurable thresholds to determine how the risk scores will be calculated.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class RiskGlobalThresholds extends BaseConfiguration {
    public static final String RISK_GLOBAL_THRESHOLD_SETTINGS_ID = "Configuration/risks/RiskGlobalThresholds";

    // on a scale from 0 to 100, from which number is a release at risk? (red zone)
    @Property(description = "At risk from", defaultValue = "50")
    private int atRiskFrom = 50;

    // on a scale from 0 to 100, from which number does a release need attention? (yellow zone)
    // this goes until the atRiskFrom number
    @Property(description = "Attention needed from", defaultValue = "10")
    private int attentionNeededFrom = 10;

    // the 'green' zone (OK zone) is from 0 to attentionNeededFrom number

    @PublicApiMember
    public int getAtRiskFrom() {
        return atRiskFrom;
    }

    @PublicApiMember
    public void setAtRiskFrom(final int atRiskFrom) {
        this.atRiskFrom = atRiskFrom;
    }

    @PublicApiMember
    public int getAttentionNeededFrom() {
        return attentionNeededFrom;
    }

    @PublicApiMember
    public void setAttentionNeededFrom(final int attentionNeededFrom) {
        this.attentionNeededFrom = attentionNeededFrom;
    }
}
