package com.xebialabs.xlrelease.risk.domain;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.repository.Ids;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;


@Metadata(description = "A Risk Profile", root = Metadata.ConfigurationItemRoot.CONFIGURATION, versioned = false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class RiskProfile extends BaseConfiguration {

    public static final String RISK_PROFILE = "riskProfile";

    public static final String DEFAULT_RISK_PROFILE_ID = Ids.RISK_PROFILE_CONFIGURATION_ROOT + "/RiskProfileDefault";

    @Property(description = "The name of risk profile.")
    private String title;

    @Property(description = "Is this default risk profile.", defaultValue = "false")
    private boolean defaultProfile;

    @Property(required = false)
    private Map<String, String> riskProfileAssessors = new HashMap<>();

    public RiskProfile() {
    }

    public RiskProfile(final String title) {
        this.title = title;
    }

    public int getValueFor(final String riskProfileAssessorKey, int defaultValue) {
        if (!riskProfileAssessors.containsKey(riskProfileAssessorKey)) {
            return defaultValue;
        }

        return Integer.parseInt(riskProfileAssessors.get(riskProfileAssessorKey));
    }

    public int getValueFor(final Type riskProfileAssessorType) {
        String key = riskProfileAssessorType.toString();
        Integer defaultValue = (Integer) riskProfileAssessorType.getDescriptor().getPropertyDescriptor("score").getDefaultValue();

        return getValueFor(key, defaultValue);
    }

    public void setValueFor(final Type riskProfileAssessorType, int value) {
        riskProfileAssessors.put(riskProfileAssessorType.toString(), "" + value);
    }

    @PublicApiMember
    public String getTitle() {
        return title;
    }

    @PublicApiMember
    public void setTitle(final String title) {
        this.title = title;
    }

    public boolean hasRiskAssessorEnabled(final Type type) {
        return isDefaultProfile() || riskProfileAssessors.containsKey(type.toString());
    }

    @PublicApiMember
    public boolean isDefaultProfile() {
        return DEFAULT_RISK_PROFILE_ID.equalsIgnoreCase(id);
    }

    @PublicApiMember
    public Map<String, String> getRiskProfileAssessors() {
        return riskProfileAssessors;
    }

    @PublicApiMember
    public void setRiskProfileAssessors(final Map<String, String> riskProfileAssessors) {
        this.riskProfileAssessors = riskProfileAssessors;
    }

    public static String generateRiskProfileId(String name) {
        return CONFIGURATION.getRootNodeName() + "/riskProfiles/" + name;
    }

    public static String generateRiskProfileId() {
        return generateRiskProfileId(UUID.randomUUID().toString());
    }

    public void setDefaultProfile(final boolean defaultProfile) {
        this.defaultProfile = defaultProfile;
    }
}
