/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ResolvableScriptTask;
import com.xebialabs.xlrelease.domain.variables.reference.PropertyUsagePoint;
import com.xebialabs.xlrelease.domain.variables.reference.UsagePoint;
import com.xebialabs.xlrelease.events.TaskStartOrRetryOperation;
import com.xebialabs.xlrelease.service.ExecuteTaskAction;
import com.xebialabs.xlrelease.variable.ValueWithInterpolation;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@PublicApiRef
@ShowOnlyPublicApiMembers
@Metadata(label="Script: Jython Script", versioned=false)
public class ScriptTask
extends ResolvableScriptTask {
    public static final String JYTHON_ENGINE = "jython";
    @Property
    private String script;

    @Override
    public Set<String> freezeVariablesInCustomFields(Map<String, ValueWithInterpolation> variables, Map<String, String> passwordVariables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        if (!this.isScriptInterpolationOff()) {
            String replacedScript = VariableHelper.replaceAllWithInterpolation(this.script, variables, unresolvedVariables, freezeEvenIfUnresolved);
            if (this.script != null && !this.script.equals(replacedScript)) {
                Set<String> variablesUsed = VariableHelper.collectVariables(this.script);
                Set variablesInNonInterpolatableValues = this.getRelease().getVariablesKeysInNonInterpolatableVariableValues().stream().map(v -> VariableHelper.withVariableSyntax(v)).collect(Collectors.toSet());
                variablesUsed.removeAll(variablesInNonInterpolatableValues);
                changes.addVariablesUsed(variablesUsed);
            }
            this.script = replacedScript;
        }
        return unresolvedVariables;
    }

    @Override
    protected Changes execute(String targetId, TaskStartOrRetryOperation operation) {
        return this.executeScript(targetId, operation, new ExecuteTaskAction(this));
    }

    @Override
    @PublicApiMember
    public String getScript() {
        return this.script;
    }

    @PublicApiMember
    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public String getEngine() {
        return JYTHON_ENGINE;
    }

    @Override
    public List<UsagePoint> getVariableUsages() {
        ArrayList<UsagePoint> usagePoints = new ArrayList<UsagePoint>(super.getVariableUsages());
        if (!this.isScriptInterpolationOff()) {
            usagePoints.add(new PropertyUsagePoint((ConfigurationItem)this, "script"));
        }
        return usagePoints;
    }
}

