/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.Variable;

@PublicApiRef
@ShowOnlyPublicApiMembers
public class PasswordStringVariable
extends Variable.VariableWithValue<String> {
    @PublicApiMember
    @Property(required=false, password=true, description="Password value of the release variable or default password value of the template variable")
    protected String value;
    @PublicApiMember
    @Property(required=false, description="Indicates this value is stored externally", nested=true)
    protected ExternalVariableValue externalVariableValue;
    @PublicApiMember
    @Property(required=false, defaultValue="false", description="If checked variable value will be multiline text ")
    protected boolean multiline;

    @Override
    @PublicApiMember
    public String getValue() {
        return this.value;
    }

    @Override
    public String getEmptyValue() {
        return "";
    }

    @Override
    @PublicApiMember
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void setUntypedValue(Object newValue) {
        this.setValue(newValue != null ? newValue.toString() : null);
    }

    @PublicApiMember
    public boolean isMultiline() {
        return this.multiline;
    }

    @PublicApiMember
    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    @Override
    public boolean isPassword() {
        return true;
    }

    @Override
    public String getValueAsString() {
        return this.formatValueAsString(this.getValue());
    }

    @Override
    public String getEmptyValueAsString() {
        return this.formatValueAsString(this.getEmptyValue());
    }

    @Override
    public boolean isValueAssignableFrom(Object value) {
        return value instanceof String;
    }

    private String formatValueAsString(Object valueToFormat) {
        return String.valueOf(valueToFormat);
    }

    public ExternalVariableValue getExternalVariableValue() {
        return this.externalVariableValue;
    }

    public void setExternalVariableValue(ExternalVariableValue externalVariableValue) {
        this.externalVariableValue = externalVariableValue;
    }

    public void checkExternalPasswordVariable() {
        if (this.externalVariableValue != null) {
            Preconditions.checkArgument((!this.requiresValue && !this.showOnReleaseStart ? 1 : 0) != 0, (Object)"Password variables with external values must have requiresValue and showOnReleaseStart flags unchecked");
        }
    }
}

