/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlrelease.domain.variables.StringVariable;
import com.xebialabs.xlrelease.domain.variables.ValueProviderConfiguration;
import java.util.List;
import org.springframework.util.StringUtils;

public class ReferenceVariable
extends StringVariable {
    public static final String VARIABLE_DELEGATE = "RESOLVE_VARIABLE_VALUE";
    @PublicApiMember
    @Property(required=true, description="The type of the reference, ie: jenkins.Server")
    protected String referencedType;

    public String getReferencedType() {
        return this.referencedType;
    }

    public void setReferencedType(String referencedType) {
        this.referencedType = referencedType;
    }

    @Override
    public void setUntypedValue(Object newValue) throws IllegalArgumentException {
        if (newValue instanceof String) {
            this.setValue((String)newValue);
        } else if (newValue == null) {
            this.setValue(this.getEmptyValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot set instance of %s into ReferenceVariable variable value: %s", newValue.getClass().getSimpleName(), newValue));
        }
    }

    @Override
    public void setValueProvider(ValueProviderConfiguration valueProvider) {
        if (valueProvider != null) {
            super.setValueProvider(valueProvider);
        }
    }

    @Override
    @ControlTask(delegate="RESOLVE_VARIABLE_VALUE")
    public Object getInternalValue() {
        List cis = (List)this.getType().getDescriptor().getControlTask("getInternalValue").invoke((ConfigurationItem)this);
        if (cis.isEmpty()) {
            String message = StringUtils.hasLength((String)this.value) ? String.format("Unable to resolve reference %s of type %s for variable ${%s}", this.value, this.referencedType, this.key) : String.format("The variable ${%s} has no value for referenced type: %s", this.key, this.referencedType);
            throw new IllegalStateException(message);
        }
        return cis.get(0);
    }
}

