package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Preconditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.BaseConfiguration;

import static com.xebialabs.deployit.plugin.api.udm.Metadata.ConfigurationItemRoot.CONFIGURATION;

@Metadata(root = CONFIGURATION, versioned = false)
public class PollingSettings extends BaseConfiguration {
    public static final String POLLING_SETTINGS_ID = "Configuration/settings/PollingSettings";

    @Property(defaultValue = "1", required = false, label = "Status interval (seconds)")
    private Integer taskStatusInterval;

    @Property(defaultValue = "30", required = false, label = "List interval (seconds)")
    private Integer taskListInterval;

    public Integer getTaskStatusInterval() {
        return taskStatusInterval;
    }

    public void setTaskStatusInterval(Integer taskStatusInterval) {
        this.taskStatusInterval = taskStatusInterval;
    }

    public Integer getTaskListInterval() {
        return taskListInterval;
    }

    public void setTaskListInterval(Integer taskListInterval) {
        this.taskListInterval = taskListInterval;
    }

    public void validate() {
        Preconditions.checkArgument(taskStatusInterval > 0, "Task status polling interval must be greater than 0 seconds.");
        Preconditions.checkArgument(taskListInterval > 0, "Task list polling interval must be greater than 0 seconds.");
    }
}
