package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.plugin.api.reflect.Type;

import static com.xebialabs.deployit.booter.local.utils.Strings.deCamelize;
import static org.apache.commons.lang3.text.WordUtils.capitalize;

public class TaskDefinition {

    public static final String XLRELEASE_GROUP_REPLACEMENT = "Core";
    public static final String XLRELEASE_GROUP = "xlrelease";
    public static final String XEBIALABS_GROUP = "xebialabs";
    protected String typeName;
    protected String displayGroup;
    protected String displayName;
    protected boolean allowed;

    public TaskDefinition(Type type, boolean allowed) {
        this.typeName = type.toString();

        this.displayGroup = getDisplayGroup(type);
        this.displayName = getDisplayName(type);
        this.allowed = allowed;
    }

    public static String getDisplayGroup(Type type) {
        String prefix = getPrefix(type);
        return isCore(prefix) ? XLRELEASE_GROUP_REPLACEMENT : prefix;
    }

    public static String getDisplayName(Type type) {
        String label = type.getDescriptor().getLabel();

        // When label annotation is missing, the type system prefix it with the group, this is not what we want
        String groupPrefix = getPrefix(type) + ": ";
        if (label.startsWith(groupPrefix)) {
            label = label.replace(groupPrefix, "");
        }

        return label;
    }

    public String getTypeName() {
        return typeName;
    }

    public String getDisplayGroup() {
        return displayGroup;
    }

    public String getDisplayName() {
        return displayName;
    }

    public boolean isAllowed() {
        return allowed;
    }

    //

    protected static String getPrefix(Type type) {
        if (type.getDescriptor().getLabel().contains(":")) {
            return type.getDescriptor().getLabel().split(":")[0];
        } else if (isCore(type.getPrefix())) {
            return type.getPrefix();
        } else {
            return capitalize(deCamelize(type.getPrefix()).toLowerCase());
        }
    }

    protected static boolean isCore(final String prefix) {
        return prefix.equalsIgnoreCase(XLRELEASE_GROUP) || prefix.equalsIgnoreCase(XEBIALABS_GROUP);
    }

}
